﻿$IntuneDeployScriptDir = "C:\ProgramData\IntuneDeployedScripts"
if(!(Test-Path $IntuneDeployScriptDir)){
    New-Item -ItemType Directory -Path $IntuneDeployScriptDir -Force
}

Function Log-Message{
    param (
        [string]$message,
        [string]$Logfile = "C:\ProgramData\IntuneDeployedScripts\DTBC-0078_STIG.log"   
    )
    $Timestamp = Get-Date -Format "yyyy-MM-dd HH:mm:ss"
    "$Timestamp - $message" | Out-File -FilePath $Logfile -Append
}

Try {
    $HelpMeWriteSettings = Get-ItemPropertyValue 'HKLM:\Software\Policies\Google\Chrome' -Name HelpMeWriteSettings
    if($HelpMeWriteSettings -eq 2){
        Log-Message -message "HelpMeWriteSettings configured value: $HelpMeWriteSettings"
        Exit 0
    } else {
        Log-Message -message "HelpMeWriteSettings configured incorrect value: $HelpMeWriteSettings"
        Exit 1
    }
} Catch {
    Log-Message -message "The property does not exist or an error occurred: $_"
    Exit 1
}